package gov.va.genisis2Test.boImp;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.LoggerFactory;

import gov.va.genisis2.bo.BusinessHelper;
import gov.va.genisis2.model.CommentHistory;
import gov.va.genisis2.model.Request;
import gov.va.genisis2.model.RequestHistory;
import gov.va.genisis2.model.RequestType;
import gov.va.genisis2.model.RoleType;
import gov.va.genisis2.model.Source;
import gov.va.genisis2.model.StudyApproval;
import gov.va.genisis2.model.UserApprover;
import gov.va.genisis2.model.UserRoleType;
import gov.va.genisis2.model.UserType;
import gov.va.genisis2.model.Users;
import gov.va.genisis2.model.WorkflowStatus;
import gov.va.genisis2Test.abstractClass.AbstractMockMvcTests;
import gov.va.genisis2Test.util.Helper;

/**
 * The Class BusinessHelperTest.
 *
 * @author Getaneh Kassahun
 * 
 *         The Class BusinessHelperTest.
 * 
 *         Description: In this BusinessHelperTest Class which extends the
 *         abstract class, AbstractMockMvcTests, junit tests are defined.
 */

public class BusinessHelperTest extends AbstractMockMvcTests {

	/** The logger. */
	private final org.slf4j.Logger logger = LoggerFactory.getLogger(BusinessHelperTest.class);

	/**
	 * Test get todays date.
	 */
	@Test
	public void testGetTodaysDate() {
		assertNotNull(BusinessHelper.getTodaysDate());
	}

	/**
	 * Test handle request payload 1.
	 */
	@Test
	public void testHandleRequestPayload() {
		Request request = Helper.getNewRequest();
		assertNotNull(request);
		assertEquals(1, request.getId());
		assertEquals("Postman Sample Create Request", request.getTitle());
		assertEquals("This is a sample new request for demo purposes", request.getDescription());
		assertEquals(1, request.getRequestTypeID());
		assertEquals(1, request.getSourceID());
		assertEquals(176, request.getStudyApprovalID());
		assertEquals("genisisresearcher1@gmail.com", request.getCreatedBy());
		assertNotNull(request.getCreatedOn());
		assertEquals("genisisresearcher1@gmail.com", request.getModifiedBy());
		assertNotNull(request.getModifiedOn());
		assertEquals(1, request.getType());
		assertEquals("taskId", request.getTaskId());
		assertEquals(1, request.getProcessId());
		assertEquals("genisismger1@gmail.com", request.getApproverId());
		assertNotNull(request.getRequestHistories());
		assertEquals("StatusDescription", request.getStatusDescription());
		assertNotNull(BusinessHelper.handleRequestPayload(request));
		logger.info(request.toString());

		Request request1 = Helper.getNewRequest1();
		assertNotNull(request1);

		Request request2 = Helper.getNewRequest2();
		assertNotNull(request2);
	}

	/**
	 * Test to verify RequestHistory
	 */
	@Test
	public void testHandleRequestHistory() {
		RequestHistory requestHistory = Helper.getNewRequestHistory();
		assertNotNull(requestHistory);
		assertEquals(1, requestHistory.getHistLineNo());
		assertNotNull(requestHistory.getRequest());
		assertEquals(1, requestHistory.getProcessId());
		assertEquals("Postman Sample Create Request - Updated", requestHistory.getTitle());
		assertEquals("This is a sample new request for demo purposes - updated", requestHistory.getDescription());
		assertEquals("Draft", requestHistory.getStatusDescription());
		assertEquals(1, requestHistory.getRequestTypeId());
		assertEquals(1, requestHistory.getSourceId());
		assertEquals(1, requestHistory.getStudyApprovalId());
		assertNotNull(requestHistory.getCreatedOn());
		assertNotNull(requestHistory.getModifiedOn());
		assertEquals("genisisdatamgr1@gmail.com", requestHistory.getCreatedBy());
		assertEquals("researcher1", requestHistory.getModifiedBy());
		assertEquals("genisisdatamgr2@gmail.com", requestHistory.getApproverId());
		assertEquals("taskId", requestHistory.getTaskId());
		logger.info(requestHistory.toString());
		
		RequestHistory requestHistory1 = Helper.getNewRequestHistory1();
		assertNotNull(requestHistory1);
	}
		
	/**
	 * Test handle study approval payload.
	 */
	@Test
	public void testHandleStudyApprovalPayload() {
		StudyApproval studyApproval = Helper.getNewStudyApproval();
		assertNotNull(studyApproval);
		assertNotNull(studyApproval.getAssociatedApprovals());
		assertEquals("Postman sample study approval", studyApproval.getTitle());
		assertEquals("this is a study approval for demo purposes", studyApproval.getDescription());
		assertEquals("researcher1", studyApproval.getCreatedBy());
		assertNotNull(studyApproval.getModifiedOn());
		assertEquals("approvalIdObtained", studyApproval.getApprovalIdObtained());
		assertEquals("datamanager1", studyApproval.getModifiedBy());
		assertEquals("researcher1", studyApproval.getCreatedBy());
		assertNotNull(studyApproval.getRequests());
		assertNotNull(BusinessHelper.handleStudyApprovalPayload(studyApproval));
		
		StudyApproval studyApproval1 = Helper.getNewStudyApproval1();
		assertNotNull(studyApproval1);
		
		StudyApproval studyApproval2 = Helper.getNewStudyApproval2();
		assertNotNull(studyApproval2);
	}

	/**
	 * Test handle comment payload 1 a.
	 */
	@Test
	public void testHandleCommentPayload() {
		CommentHistory commentHistory = Helper.getCommentHistory();
		assertNotNull(commentHistory);
		assertEquals(1, commentHistory.getCommentId());
		assertNotNull(commentHistory.getRequest());
		assertNotNull(commentHistory.getWorkflowStatus());
		assertEquals(4, commentHistory.getWorkflowStatus().getId());
		assertEquals("Returned", commentHistory.getWorkflowStatus().getDescription());
		assertNotNull(commentHistory.getWorkflowStatus().getCommentHistories());
		assertEquals("Returned request", commentHistory.getComments());
		assertNotNull(commentHistory.getCreatedOn());
		assertEquals("datamanger1", commentHistory.getCreatedBy());
		assertEquals(1, commentHistory.getRequestId());
		assertEquals("status", commentHistory.getStatus());
		assertEquals("type", commentHistory.getType());
		assertEquals("taskId", commentHistory.getTaskId());
		logger.info(commentHistory.toString());
		
		CommentHistory commentHistory1 = Helper.getCommentHistory1();
		assertNotNull(commentHistory1);
		
		CommentHistory commentHistory2 = Helper.getCommentHistory2();
		assertNotNull(commentHistory2);
	}

	/**
	 * Test prepare study approval response payload 1 a.
	 */
	@Test
	public void testPrepareStudyApprovalResponsePayload() {
		// is null study approval
		logger.info("**********Junit Test PrepareStudyApprovalResponsePayload**********");
		assertNotNull(BusinessHelper.prepareStudyApprovalResponsePayload(Helper.getListOfStudyApproval()));
		logger.info("**********End of Junit Test PrepareStudyApprovalResponsePayload**********");
	}

	/**
	 * Test prepare comment history response payload 1 a.
	 */
	@Test
	public void testPrepareCommentHistoryResponsePayload() {
		// is null Comment History
		logger.info("**********Junit Test PrepareCommentHistoryResponsePayload**********");
		assertNotNull(BusinessHelper.prepareCommentHistoryResponsePayload(Helper.getListOfCommentHistory()));
		logger.info("**********End of Junit Test PrepareStudyApprovalResponsePayload**********");
	}

	/**
	 * Test prepare comment history response payload 2.
	 */

	@Test
	public void testPrepareCommentHistoryResponsePayload_2() {
		// is not null Comment History
		logger.info("**********Junit Test PrepareCommentHistoryResponsePayload**********");
		CommentHistory commentHistory = new CommentHistory(2, null, null, "commentsTestOne", new Date(),
				"createdByTestOne", "taskIdTestOne");
		int id = 4;
		Request request = Helper.getExistingRequest();

		commentHistory.setRequestId(id);
		commentHistory.setRequest(request);
		getMockHibernateTemplate().save(request);
		WorkflowStatus workflowStatus = new WorkflowStatus(1, "descriptionTestOne", null);
		commentHistory.setWorkflowStatus(workflowStatus);
		getMockHibernateTemplate().save(workflowStatus);
		getMockHibernateTemplate().save(commentHistory);
		List<CommentHistory> commentHistoryList1 = new ArrayList<CommentHistory>();
		commentHistoryList1.add(commentHistory);
		commentHistoryList1 = BusinessHelper.prepareCommentHistoryResponsePayload(commentHistoryList1);
		logger.info("**********End of Junit Test PrepareStudyApprovalResponsePayload**********");
	}

	/**
	 * Test prepare request response payload 1 a.
	 */
	@Test
	public void testPrepareRequestResponsePayload() {
		// is null request
		logger.info("**********Junit Test RequestResponsePayload**********");
		List<Request> requestList1 = BusinessHelper.prepareRequestResponsePayload(null);
		Assert.assertEquals(Collections.emptyList(), requestList1);
		logger.info("**********End of Junit Test PrepareRequestResponsePayload**********");
	}

	/**
	 * Test prepare request response payload 1 b.
	 */
	@Test
	public void testPrepareRequestResponsePayload_1() {
		// Size is zero request
		logger.info("**********Junit Test PrepareRequestResponsePayload**********");
		assertNotNull(BusinessHelper.prepareRequestResponsePayload(Helper.getListOfRequest()));
		logger.info("**********End of Junit Test PrepareRequestResponsePayload**********");
	}
	
	/**
	 * Test to verify RoleType 
	 */
	@Test
	public void testRoleType() {
		RoleType roleType = Helper.getNewRoleType();
		assertNotNull(roleType);
		assertEquals(1, roleType.getRoleTypeId());
		assertEquals("Administrator", roleType.getRoleName());
		assertEquals("Administrator", roleType.getRoleDescription());
		assertNull(roleType.getUserRoleTypes());

		RoleType roleType1 = Helper.getNewRoleType1();
		assertNotNull(roleType1);

		RoleType roleType2 = Helper.getNewRoleType2();
		assertNotNull(roleType2);
	}

	/**
	 * Test to verify UserType 
	 */
	@Test
	public void testUserType() {
		UserType userType = Helper.getNewUserType();
		assertNotNull(userType);
		assertEquals(1, userType.getUserTypeId());
		assertEquals("Employee", userType.getUserTypeDesc());
		assertNull(userType.getUserRoleTypes());

		UserType userType1 = Helper.getNewUserType1();
		assertNotNull(userType1);

		UserType userType2 = Helper.getNewUserType2();
		assertNotNull(userType2);
	}
	
	/**
	 * Test to verify UserRoleType 
	 */
	@Test
	public void testUserRoleType() {
		UserRoleType userRoleType = Helper.getNewUserRoleType();
		assertNotNull(userRoleType);
		assertEquals(1, userRoleType.getId());
		assertNotNull(userRoleType.getRoleType());
		assertNotNull(userRoleType.getUsers());
		assertNotNull(userRoleType.getUserType());
		assertNotNull(userRoleType.getStartDate());
		assertNotNull(userRoleType.getEndDate());
		
		UserRoleType userRoleType1 = Helper.getNewUserRoleType1();
		assertNotNull(userRoleType1);
		
		UserRoleType userRoleType2 = Helper.getNewUserRoleType2();
		assertNotNull(userRoleType2);
	}
	
	/**
	 * Test to verify Source 
	 */
	@Test
	public void testSource() {
		Source source = Helper.getNewSource();
		assertNotNull(source);
		assertEquals(1, source.getId());
		assertEquals("Survey", source.getDescription());
		assertNotNull(source.getRequests());
		
		Source source1 = Helper.getNewSource1();
		assertNotNull(source1);
		
		Source source2 = Helper.getNewSource2();
		assertNotNull(source2);
	}
	
	/**
	 * Test to verify Users object
	 */
	@Test
	public void testUsers() {
		Users user = Helper.getNewUser();
		assertNotNull(user);
		assertEquals(1, user.getUserId());
		assertEquals("fNmae", user.getFirstName());
		assertEquals("mName", user.getMiddleName());
		assertEquals("lName", user.getLastName());
		assertEquals("lName2", user.getLastName2());
		assertNotNull(user.getCreateDate());
		assertEquals("genisisdatamgr1@gmail.com", user.getEmailId());
		assertEquals(1, user.getUserActive());
		assertNotNull(user.getActiveDate());
		assertNotNull(user.getInactiveDate());
		assertNotNull(user.getUserApproversForUserId());
		assertNotNull(user.getUserRoleTypes());
		assertNotNull(user.getUserApproversForUserApproverId());
		assertEquals("role", user.getRole());
		assertEquals("datamanager1", user.getApprover());
		
		Users user1 = Helper.getNewUser1();
		assertNotNull(user1);
		
		Users user2 = Helper.getNewUser2();
		assertNotNull(user2);
	}
	
	/**
	 * Test to verify RequestType
	 */
	@Test
	public void testRequestType() {
		RequestType requestType = Helper.getNewRequestType();
		assertNotNull(requestType);
		assertEquals(1, requestType.getId());
		assertEquals("Aggregate", requestType.getDescription());
		assertNotNull(requestType.getRequests());
		
		RequestType requestType1 = Helper.getNewRequestType1();
		assertNotNull(requestType1);
		
		RequestType requestType2 = Helper.getNewRequestType2();
		assertNotNull(requestType2);
	}
	
	/**
	 * Test to verify UserApprover
	 */
	@Test
	public void testUserApprover() {
		UserApprover userApprover = Helper.getNewUserApprover();
		assertNotNull(userApprover);
		assertEquals(1, userApprover.getId());
		assertNotNull(userApprover.getUsersByUserApproverId());
		assertNotNull(userApprover.getUsersByUserId());
		
		UserApprover requestType1 = Helper.getNewUserApprover1();
		assertNotNull(requestType1);
	}
}
